﻿using System;
using System.IO;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.Serialization.Formatters.Soap;

namespace Life
{
    public partial class Form1 : Form
    {
        const int CELL = 16;

        Field F;

        public Form1()
        {
            
            F= new Field(60,40);
            InitializeComponent();
            Size = new Size(CELL*F.N+18,CELL*F.M+66);
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            F.Paint(e.Graphics, CELL, menuStrip1.Height+1);
        }
        protected override void OnMouseClick(MouseEventArgs e)
        {
            int i = e.X / CELL;
            int j = (e.Y - menuStrip1.Height - 1) / CELL;

            switch (e.Button)
            {
                case MouseButtons.Left:
                    F[i, j] = 1;
                    break;
                case MouseButtons.Right:
                    F[i, j] = 0;
                    break;
            }
            Rectangle R = new Rectangle(i * CELL, j * CELL + menuStrip1.Height + 1, CELL, CELL);
            Invalidate(R);

        }

        protected override void OnMouseMove(MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left || e.Button == MouseButtons.Right) 
            OnMouseClick(e);
        }

        private void clearToolStripMenuItem_Click(object sender, EventArgs e)
        {
            F.Zero();
            Invalidate();
        }

        private void randomToolStripMenuItem_Click(object sender, EventArgs e)
        {
            F.Rand(); Invalidate();
        }

        private void startToolStripMenuItem_Click(object sender, EventArgs e)
        {
            timer1.Start();
        }

        private void stopToolStripMenuItem_Click(object sender, EventArgs e)
        {
            timer1.Stop();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            F.Step(this,CELL, menuStrip1.Height + 1);
        }

        protected override void OnKeyDown(KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Space:
                    timer1.Enabled = !timer1.Enabled;
                    break;
            }
        }

        private void saveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog()==DialogResult.OK)
            {
                FileStream file = new FileStream(saveFileDialog1.FileName, FileMode.Create);
                SoapFormatter formatter = new SoapFormatter();
                formatter.Serialize(file, F);
                file.Close();
            }
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog()==DialogResult.OK)
            {
                try
                {
                    FileStream file = new FileStream(openFileDialog1.FileName, FileMode.Open);
                    SoapFormatter formatter = new SoapFormatter();
                    F=(Field)formatter.Deserialize(file);
                    file.Close();
                    Invalidate();
                }
                catch
                {
                    MessageBox.Show("Ошибка открытия файла","Life by Convey",
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                }

            }
        }
    }
}
