﻿using System;
using System.Windows.Forms;
using System.Drawing;

namespace Life
{
    [Serializable]
    internal class Field
    {
        public readonly int N = 40;
        public readonly int M = 30;

        private int[,] A, B;

        public Field(int N=40, int M=30)
        { 
            this.N = N;  this.M = M;
            A = new int[N, M]; Zero();
            B = new int[N, M];
        }

        public void Zero()
        {
            for (int i = 0; i < N; i++) 
                for (int j = 0; j < M; j++)
                    A[i, j] = 0;
        }

        public void Rand()
        {
            Random random = new Random();

            for (int i = 0; i < N; i++)
                for (int j = 0; j < M; j++)
                    A[i, j] = random.Next(2);
        }


        public int Around(int I, int J)
        {
            int n = 0;
            for (int i=I-1; i<=I+1; i++)
            {
                int x = i; if (x < 0) x = N - 1; if (x >= N) x = 0;
                for (int j=J-1; j<=J+1; j++)
                {
                    int y = j; if (y < 0) y = M - 1; if (y >= M) y = 0;
                    n += A[x, y];
                }
            }
            n -= A[I, J];
            return n;
        }

        public void Step(Form f, int D, int H)
        {
            for (int i = 0; i<N; i++)
                for (int j = 0; j<M; j++)
                    switch (Around(i, j))
                    {
                        case 2:
                            B[i, j] = A[i, j];
                            break;
                        case 3:
                            B[i, j] = 1;
                            break;
                        default:
                            B[i, j] = 0;
                            break;
                    }

            for (int i = 0; i < N; i++)
                for (int j = 0; j < M; j++)
                    if (A[i, j] != B[i, j])
                    {
                        A[i, j] = B[i, j];
                        Rectangle R = new Rectangle(i * D, j * D + H, D, D);
                        f.Invalidate(R);
                    }

        }

        public void Paint(Graphics g, int S, int H)
        {
            for (int i = 0; i < N; i++)
                for (int j = 0; j < M; j++)
                    if (A[i, j] == 0)
                        g.FillRectangle(Brushes.White, i * S, j * S +H, S - 1, S - 1);
                    else
                        g.FillRectangle(Brushes.Black, i * S, j * S + H, S - 1, S - 1);
        }

        public int this[int i, int j]
        {
            get
            {
                if (i >= 0 && j >= 0 && i < N && j < M)
                    return A[i, j];
                else return 0;
            }
            set
            {
                if (i >= 0 && j >= 0 && i < N && j < M)
                    A[i, j] = value;
            }
        }

    }
}
