﻿#define _CRT_SECURE_NO_WARNINGS
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define NN 32
#define MM 3

#define CPP 1
#define CS  2
#define PYTHON 4
#define SQL 8
#define HTML 16
#define MAN 32


struct Stud
{
	char Name[NN];
	int Year;
	int topics;
};

typedef Stud* PStud;

void StudInit(PStud P, const char* name, int year)
{
	strcpy_s(P->Name, NN - 1, name);
	P->Year = year;
	P->topics = 0;
}

PStud StudCreate(const char* name, int year)
{
	PStud P = (PStud)malloc(sizeof(Stud));
	StudInit(P, name, year);
	return P;
}

PStud StudCreate()
{
	char Buf[NN];
	int year;
	printf("Name ->"); gets_s(Buf, NN - 1);
	printf("Year ->"); scanf("%d", &year);
	return StudCreate(Buf, year);
}

void StudAdd(PStud P, int subj)
{
	P->topics |= subj;
}

void StudDel(PStud P, int subj)
{
	P->topics &= ~subj;
}


void StudPrint(PStud P)
{
	printf("%s %d ", P->Name, P->Year);
	if (P->topics & CPP) printf("C++ ");
	if (P->topics & CS)  printf("C# ");
	if (P->topics & PYTHON)  printf("Python ");
	if (P->topics & SQL)  printf("SQL ");
	if (P->topics & HTML)  printf("HTML ");
	printf("\n");
}

void StudWrite(PStud P, FILE* f)
{
	fwrite(P, sizeof(Stud), 1, f);
}

void StudRead(PStud P, FILE* f)
{
	fread(P, sizeof(Stud), 1, f);
}


int main()
{	PStud Class[MM];

	Class[0] = StudCreate();
	Class[1] = StudCreate("Petrov", 2025);
	Class[2] = StudCreate("Sidorov", 2025);
	
	StudAdd(Class[0], CPP | CS);
	StudAdd(Class[1], CPP | HTML);
	StudAdd(Class[1], PYTHON);
	StudDel(Class[1], HTML);
	StudAdd(Class[2], SQL);

	for (int i = 0; i < MM; i++) StudPrint(Class[i]);

	FILE* f = fopen("students.bin", "wb");
	for (int i = 0; i < MM; i++) StudWrite(Class[i], f);
	fclose(f);

	printf("===== From File ======== \n");

	Stud St;
	f = fopen("students.bin", "rb");
	while (fread(&St, sizeof(Stud), 1, f))
	{
		StudPrint(&St);
	}
	fclose(f);
}
