﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace Figures
{
    public partial class Form1 : Form
    {
        Figs figs = new Figs();

        public Form1()
        {
            InitializeComponent();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {          
            figs.Draw(e.Graphics);
        }

        private void panel1_Resize(object sender, EventArgs e)
        {
            panel1.Invalidate();
        }

        private void panel1_MouseDown(object sender, MouseEventArgs e)
        {
            bool b=true;
            switch (e.Button)             
            {
                case MouseButtons.Left:
                    b=figs.Add(new Circle(e.X, e.Y));
                    break;
                case MouseButtons.Right:
                    b=figs.Add(new Rect(e.X, e.Y));
                    break;
                case MouseButtons.Middle:
                    b = figs.Add(new FilledCircle(e.X, e.Y));
                    break;

            }
            panel1.Invalidate();
            if (!b) MessageBox.Show("Число фигур достигло максимума",
                                    "Добавление фигуры",
                                    MessageBoxButtons.OK, 
                                    MessageBoxIcon.Information);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            figs.Step(panel1.ClientRectangle);
            panel1.Invalidate();
        }

        private void startToolStripMenuItem_Click(object sender, EventArgs e)
        {
            timer1.Start();
        }

        private void stopToolStripMenuItem_Click(object sender, EventArgs e)
        {
            timer1.Stop();
        }
    }
}
