﻿using System;
using System.Drawing;

namespace Figures
{
    class Figs
    {
        readonly int Max;
        int Total = 0;
        Circle[] circles;
        public Figs(int max = 100) 
        { 
            circles = new Circle[Max=max];
        }

        public bool Add(Circle circle)
        { 
            if (Total<Max)
            { 
                circles[Total++] = circle;
                return true;
            }
            return false;   
        }

        public void Draw(Graphics g)
        {
            for (int i = 0; i<Total; i++)
                circles[i].Draw(g);
        }

        public void Step(Rectangle R)
        {
            for (int i = 0;i<Total;i++)
                circles[i].Step(R);
        }

    }
    class Circle
    {
        protected int x, y;
        protected Pen p;
        protected int r;

        private Random Rnd = new Random();
        private int vx, vy;
        
        public Circle(int x, int y)
        {
            this.x = x;
            this.y = y;
            p = new Pen(Color.FromArgb(Rnd.Next(256), 0, Rnd.Next(256)));
            r = Rnd.Next(10,20);
            vx = Rnd.Next(7) - 3;
            vy = Rnd.Next(7) - 3;
        }


        public void Step(Rectangle R)
        {
            x += vx; 
            if (x+r >= R.Right) vx = -Math.Abs(vx);
            else if (x-r<=0) vx = Math.Abs(vx);

            y += vy;
            if (y+r >= R.Bottom) vy = -Math.Abs(vy);
            else if (y-r <=0) vy = Math.Abs(vy);

        }
        public virtual void Draw(Graphics g)
        {
            g.DrawEllipse(p, x - r, y - r, 2 * r, 2 * r);
        }

    }

    class Rect : Circle
    {
        public Rect(int x, int y) : base(x, y) { }
        public override void Draw(Graphics g)
        {
            g.DrawRectangle(p, x - r, y - r, 2 * r, 2 * r);
        }
    }

    class FilledCircle : Circle
    {
        protected Brush brush;
        public FilledCircle(int x, int y) : base(x, y)
        {
            brush = new SolidBrush(p.Color);
        }
        public override void Draw(Graphics g)
        {
            g.FillEllipse(brush, x - r, y - r, 2*r, 2*r);
        }
    }
}
