﻿interface Polygon
{
    public int NUM
    {
        get;
    }
}

abstract class Figure
{
    protected int x, y;
    abstract public void Paint();
    public override string ToString()
    {
        return GetType().ToString()+" x="+x+", y="+y;
    }
    
}

class Square: Figure, Polygon
{
    protected int Num;
        public int NUM
    {   get { return Num; }
    }
    public Square() { Num = 4; }
    public override void Paint()   {   Console.WriteLine("Square");  }
}

class Hexagon: Square
{
    public Hexagon() { Num = 6; }
    public override void Paint()   {   Console.WriteLine("Hexagon");  }
}

class Circle: Figure
{    public override void Paint()   {  Console.WriteLine("Circle");  }
}

internal class Program
{
    private static void Main(string[] args)
    {
        Figure[] f = new Figure[4];
        f[0]= new Hexagon();
        f[1] = new Square();
        f[2]= new Hexagon();
        f[3] = new Circle();

        for (int i = 0; i < f.Length; i++)
        {
            f[i].Paint();
            Console.WriteLine(f[i]);
            if (f[i] is Polygon)
            {
                Polygon p = (Polygon) f[i];
                Console.WriteLine(p.NUM);
            }
            
        }

    }
}