﻿using System.Security.Cryptography;

class Point
{
    private int x, y;

    public Point(int x=0, int y=0)
    {
        X = x; Y = y;
    }

    public int X
    {
        get { return x; }
        set 
        {
            if (value < 0 || value>=4096) throw new WrongCoords("X");
            x = value; 
        }
    }

    public int Y
    {
        get { return y; }
        set
        {
            if (value < 0 || value >= 4096) throw new WrongCoords("Y"); 
            y = value;
        }
    }

    public override string ToString()
    {
        return "("+x+","+y+")";
    }

    public static Point operator+(Point p1, Point p2)
    {
        return new Point(p1.X+p2.X, p1.Y+p2.Y);
    }
    public static Point operator -(Point p1, Point p2)
    {
        return new Point(p1.X - p2.X, p1.Y - p2.Y);
    }

    public static Point operator*(Point p1, int n)
    {
        return new Point(p1.X*n, p1.Y*n);
    }

    public double Abs
    {
        get { return Math.Sqrt(x*x + y*y); }
    }

    public static bool operator>(Point p1, Point p2)
    {
        return p1.Abs > p2.Abs;
    }

    public static bool operator<(Point p1, Point p2)
    {
        return p1.Abs < p2.Abs;
    }

    public static bool operator==(Point p1, Point p2)
    {
        return (p1.X == p2.X) && (p1.Y == p2.Y);
    }

    public static bool operator !=(Point p1, Point p2)
    {
        return (p1.X != p2.X) || (p1.Y != p2.Y);
    }


}

class WrongCoords: Exception
{
    public WrongCoords(string msg): base (msg) { }
    public override string Message => "Wrong "+base.Message;
}


internal class Program
{
    private static void Main(string[] args)
    {

       try
        {
            Point p = new Point(50, 60);
            Point q = new Point(40, 90);
            Console.WriteLine(p);
            Console.WriteLine(q);
            Point s = (p + q)*2;
            Console.WriteLine(s);
            if (p > q) { Console.WriteLine("P>Q"); }
            else { Console.WriteLine("P<Q"); }
            if (p != q) { Console.WriteLine("Точки разные"); }
            else { Console.WriteLine("Точки одинаковые"); }
        }
        catch (ArgumentOutOfRangeException e)
        {
            Console.WriteLine("Отрицательный аргумент");
        }
        catch (Exception e)
        {
            // Console.WriteLine(e.GetType());
            Console.WriteLine(e.Message);
            // Console.WriteLine(e.StackTrace);
        }


    }
}